<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/*
--------------------------------------
📩 فرم ارسال رضایت مشتری | سلام بابا
نسخه نهایی با chat_id عددی و گزارش خطای دقیق
--------------------------------------
*/

// ===== تنظیمات اولیه =====
$BOT_TOKEN = "490048283:AAGEC4Cj0c8SkIicNrMXl7QNDLC2rKK5LAs";
$CHAT_ID = "-1001061299857"; // chat_id عددی کانال خصوصی سلام بابا

// ===== توابع کمکی =====
function sanitize($v) {
  return htmlspecialchars(trim($v), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function sendTelegram($url, $fields) {
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
  $res = curl_exec($ch);
  echo "<pre>";
var_dump($res);
echo "</pre>";
  $err = curl_error($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  $json = json_decode($res, true);
  if ($err) {
    echo "❌ خطا در ارتباط با تلگرام: $err";
    exit;
  }
  if (!$json['ok']) {
    echo "❌ خطا از سمت تلگرام:\nکد: $code\nتوضیح: " . $json['description'];
    exit;
  }
  return $json;
}

// ===== دریافت داده‌ها =====
$name = sanitize($_POST['name'] ?? '');
$province = sanitize($_POST['province'] ?? '');
$seller = sanitize($_POST['seller'] ?? '');
$phone = sanitize($_POST['phone'] ?? '');
$product = sanitize($_POST['product'] ?? '');
$model = sanitize($_POST['model'] ?? '');
$message = sanitize($_POST['message'] ?? '');

if (!$name || !$province || !$seller || !$phone || !$product || !$model || !$message) {
  echo "⚠️ لطفاً همه فیلدها را کامل کنید.";
  exit;
}

// ===== متن پیام =====
$caption = "📹 گزارش رضایت مشتری جدید:\n\n"
          ."👤 نام: $name\n"
          ."📍 استان: $province\n"
          ."🧑‍💼 فروشنده: $seller\n"
          ."📞 شماره: $phone\n"
          ."📦 کالا: $product\n"
          ."🔖 مدل: $model\n"
          ."🕒 زمان ارسال: ".date('Y-m-d H:i:s')."\n"
          ."💬 نظر مشتری:\n$message";

// ===== ارسال پیام متنی =====
sendTelegram(
  "https://api.telegram.org/bot$BOT_TOKEN/sendMessage",
  ['chat_id' => $CHAT_ID, 'text' => $caption]
);

// ===== ارسال ویدیو =====
if (!empty($_FILES['video']['tmp_name'])) {
  $video = new CURLFile($_FILES['video']['tmp_name'], $_FILES['video']['type'], $_FILES['video']['name']);
  sendTelegram(
    "https://api.telegram.org/bot$BOT_TOKEN/sendVideo",
    ['chat_id' => $CHAT_ID, 'video' => $video, 'caption' => "🎥 ویدیوی رضایت مشتری"]
  );
}

// ===== ارسال تصویر =====
if (!empty($_FILES['photo']['tmp_name'])) {
  $photo = new CURLFile($_FILES['photo']['tmp_name'], $_FILES['photo']['type'], $_FILES['photo']['name']);
  sendTelegram(
    "https://api.telegram.org/bot$BOT_TOKEN/sendPhoto",
    ['chat_id' => $CHAT_ID, 'photo' => $photo, 'caption' => "🖼 تصویر رضایت مشتری"]
  );
}

// ===== پیام نهایی =====
http_response_code(200);
echo "🎉 ارسال کامل شد و به کانال سلام بابا فرستاده شد.";
?>
