<?php
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__.'/config.php';
$mysqli = db();
function clean($s){ return trim($s ?? ''); }

$code       = clean($_POST['code'] ?? '');
$installer  = clean($_POST['installer_name'] ?? '');
$install_date = clean($_POST['install_date'] ?? '');
$serial     = clean($_POST['serial_number'] ?? '');
$notes      = clean($_POST['notes'] ?? '');

if($code===''||$installer===''||$install_date===''||$serial===''){
  echo json_encode(['success'=>false,'error'=>'فیلدهای اجباری خالی است'], JSON_UNESCAPED_UNICODE); exit;
}

$exists=0;
$st=$mysqli->prepare("SELECT COUNT(*) FROM guarantee_requests WHERE tracking_code=?");
$st->bind_param("s",$code); $st->execute(); $st->bind_result($exists); $st->fetch(); $st->close();
if(!$exists){ echo json_encode(['success'=>false,'error':'کد رهگیری معتبر نیست'], JSON_UNESCAPED_UNICODE); exit; }

$already=0;
$st=$mysqli->prepare("SELECT COUNT(*) FROM installations WHERE tracking_code=?");
$st->bind_param("s",$code); $st->execute(); $st->bind_result($already); $st->fetch(); $st->close();
if($already){ echo json_encode(['success'=>false,'error':'برای این کد قبلاً نصب ثبت شده است'], JSON_UNESCAPED_UNICODE); exit; }

$stmt=$mysqli->prepare("INSERT INTO installations (tracking_code, installer_name, install_date, serial_number, notes) VALUES (?,?,?,?,?)");
$stmt->bind_param("sssss",$code,$installer,$install_date,$serial,$notes);
if(!$stmt->execute()){ echo json_encode(['success'=>false,'error'=>'DB insert failed: '.$stmt->error], JSON_UNESCAPED_UNICODE); exit; }
$stmt->close();

$customer_name=$province=$address=$mobile=$model=$warranty='';
$q=$mysqli->prepare("SELECT customer_name, province, address, mobile, model, warranty FROM guarantee_requests WHERE tracking_code=? LIMIT 1");
$q->bind_param("s",$code); $q->execute(); $q->bind_result($customer_name,$province,$address,$mobile,$model,$warranty); $q->fetch(); $q->close();

$lines=[];
$lines[]="<b>نصب انجام شد ✅</b>";
$lines[]="<b>کد رهگیری:</b> ".esc_html($code);
$lines[]="<b>مشتری:</b> ".esc_html($customer_name);
$lines[]="<b>استان:</b> ".esc_html($province);
$lines[]="<b>آدرس:</b> ".esc_html($address);
$lines[]="<b>همراه:</b> ".esc_html($mobile);
$lines[]="<b>مدل:</b> ".esc_html($model);
if($warranty!=='') $lines[]="<b>گارانتی:</b> ".esc_html($warranty);
$lines[]="<b>سرویس‌کار:</b> ".esc_html($installer);
$lines[]="<b>تاریخ نصب:</b> ".esc_html($install_date);
$lines[]="<b>سریال:</b> ".esc_html($serial);
if($notes!=='') $lines[]="<b>توضیحات:</b> ".esc_html($notes);
$lines[]="<i>ارسال خودکار از salambaba.co/guaranti</i>";
tg_send_message(TG_CHAT_INSTALLS, implode("\n",$lines));

echo json_encode(['success'=>true,'code'=>$code], JSON_UNESCAPED_UNICODE);
?>