<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>فرم نصب انجام‌شده | سلام‌بابا</title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="bar"></div>
    <div class="content">
      <h1>فرم نصب انجام‌شده (یک‌بارمصرف)</h1>
    </div>
  </div>

  <div class="card">
  <?php
    // One-time check
    $code = $_GET['code'] ?? '';
    $usedFile = __DIR__ . '/used_codes.json';
    if(!file_exists($usedFile)) file_put_contents($usedFile, json_encode([]));
    $used = json_decode(file_get_contents($usedFile), true);
    if(!is_array($used)) $used = [];
    if($code === ''){
      echo '<div class="error">کد رهگیری در لینک وجود ندارد.</div>';
      exit;
    }
    if(in_array($code, $used)){
      echo '<div class="warn">⚠️ این لینک قبلاً استفاده شده و دیگر قابل تکمیل نیست.</div>';
      exit;
    }

    // Collect readonly data from query
    function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
    $seller   = $_GET['seller']   ?? '';
    $customer = $_GET['customer'] ?? '';
    $province = $_GET['province'] ?? '';
    $address  = $_GET['address']  ?? '';
    $mobile   = $_GET['mobile']   ?? '';
    $model    = $_GET['model']    ?? '';
    $warranty = $_GET['warranty'] ?? '';
  ?>

  <div class="warn"><b>درگاه یک‌بارمصرف:</b> این لینک فقط یک بار قابل تکمیل است؛ پس از ارسال غیرفعال می‌شود.</div>

  <div class="preview">
    <h2>مشخصات ثبت‌شده (ویرایش‌ناپذیر)</h2>
    <div class="grid-2">
      <div><label>کد رهگیری</label><input class="disabled" value="<?php echo h($code); ?>" disabled></div>
      <div><label>فروشنده</label><input class="disabled" value="<?php echo h($seller); ?>" disabled></div>
      <div><label>نام مشتری</label><input class="disabled" value="<?php echo h($customer); ?>" disabled></div>
      <div><label>استان</label><input class="disabled" value="<?php echo h($province); ?>" disabled></div>
      <div class="grid-2" style="grid-column: 1 / -1;">
        <div><label>شماره همراه</label><input class="disabled" value="<?php echo h($mobile); ?>" disabled></div>
        <div><label>مدل کالا</label><input class="disabled" value="<?php echo h($model); ?>" disabled></div>
      </div>
      <div style="grid-column: 1 / -1;"><label>آدرس</label><textarea class="disabled" disabled><?php echo h($address); ?></textarea></div>
      <div style="grid-column: 1 / -1;"><label>گارانتی</label><input class="disabled" value="<?php echo h($warranty); ?>" disabled></div>
    </div>
  </div>

  <hr>
  <form id="installForm" action="install_send.php" method="post" enctype="multipart/form-data" novalidate>
    <!-- Hidden carry-over fields -->
    <input type="hidden" name="code" value="<?php echo h($code); ?>">
    <input type="hidden" name="seller" value="<?php echo h($seller); ?>">
    <input type="hidden" name="customer" value="<?php echo h($customer); ?>">
    <input type="hidden" name="province" value="<?php echo h($province); ?>">
    <input type="hidden" name="address" value="<?php echo h($address); ?>">
    <input type="hidden" name="mobile" value="<?php echo h($mobile); ?>">
    <input type="hidden" name="model" value="<?php echo h($model); ?>">
    <input type="hidden" name="warranty" value="<?php echo h($warranty); ?>">

    <h2>اطلاعات نصب توسط سرویس‌کار</h2>
    <div class="grid-2">
      <div>
        <label>نام سرویس‌کار</label>
        <input type="text" name="installer_name" required>
      </div>
      <div>
        <label>تاریخ نصب</label>
        <input type="text" name="install_date" placeholder="YYYY/MM/DD" required>
        <small class="help">فرمت شمسی یا میلادی؛ هرطور بنویسی همون ارسال میشه.</small>
      </div>
    </div>

    <div class="grid-2">
      <div>
        <label>شماره سریال کالا</label>
        <input type="text" name="serial_number" required>
      </div>
      <div>
        <label>عکس نصب‌شده</label>
        <input type="file" name="photo" accept="image/*" required>
      </div>
    </div>

    <label>توضیحات نصب (اختیاری)</label>
    <textarea name="notes" rows="3" placeholder="مثلاً: تنظیم کانال‌ها، تست HDR، نصب دیواری ..."></textarea>

    <h2>امضاها</h2>
    <div class="grid-2">
      <div>
        <label>امضای مشتری</label>
        <canvas id="sigCustomer"></canvas>
        <input type="hidden" name="signature_customer" id="sigCustomerInput">
        <div class="note">با انگشت یا موس امضا کنید. <button type="button" id="clearC">پاک کردن</button></div>
      </div>
      <div>
        <label>امضای سرویس‌کار</label>
        <canvas id="sigInstaller"></canvas>
        <input type="hidden" name="signature_installer" id="sigInstallerInput">
        <div class="note">با انگشت یا موس امضا کنید. <button type="button" id="clearI">پاک کردن</button></div>
      </div>
    </div>

    <div id="resp" class="note"></div>
    <br>
    <button type="submit">ثبت نهایی نصب و ارسال به تلگرام</button>
    <div class="footer">پس از ارسال موفق، این لینک برای همیشه غیرفعال خواهد شد.</div>
  </form>
  </div>
</div>

<script>
function sigPad(canvasId, inputId){
  const c = document.getElementById(canvasId);
  const i = document.getElementById(inputId);
  const ctx = c.getContext('2d');
  let drawing=false, last=null;

  function resize(){ const r=c.getBoundingClientRect(); c.width=r.width; c.height=220; ctx.lineWidth=2; ctx.lineCap='round'; ctx.strokeStyle='#111827'; ctx.fillStyle='#ffffff'; ctx.fillRect(0,0,c.width,c.height); }
  window.addEventListener('resize', resize); resize();

  function pos(e){ if(e.touches && e.touches[0]) e = e.touches[0]; const r=c.getBoundingClientRect(); return {x:e.clientX-r.left, y:e.clientY-r.top}; }
  function start(e){ drawing=true; last=pos(e); }
  function move(e){ if(!drawing) return; const p=pos(e); ctx.beginPath(); ctx.moveTo(last.x,last.y); ctx.lineTo(p.x,p.y); ctx.stroke(); last=p; }
  function end(){ drawing=false; i.value=c.toDataURL('image/png'); }

  c.addEventListener('mousedown', start); c.addEventListener('mousemove', move); window.addEventListener('mouseup', end);
  c.addEventListener('touchstart', start, {passive:true}); c.addEventListener('touchmove', move, {passive:true}); c.addEventListener('touchend', end);
  return {clear:()=>{resize(); i.value='';}};
}

const padC = sigPad('sigCustomer','sigCustomerInput');
const padI = sigPad('sigInstaller','sigInstallerInput');
document.getElementById('clearC').onclick = ()=>padC.clear();
document.getElementById('clearI').onclick = ()=>padI.clear();

document.getElementById('installForm').addEventListener('submit', async function(e){
  e.preventDefault();
  const must = ['installer_name','install_date','serial_number'];
  const fd = new FormData(this);
  let missing=[];
  must.forEach(n=>{ if(!(fd.get(n)||'').trim()) missing.push(n); });
  if(!fd.get('photo') || !fd.get('signature_customer') || !fd.get('signature_installer')){
    if(!fd.get('photo')) missing.push('photo');
    if(!(fd.get('signature_customer')||'').trim()) missing.push('signature_customer');
    if(!(fd.get('signature_installer')||'').trim()) missing.push('signature_installer');
  }
  if(missing.length){
    const resp = document.getElementById('resp');
    resp.className='error';
    resp.textContent='این فیلدها اجباری‌اند: '+missing.join(', ');
    return;
  }
  const resp = document.getElementById('resp');
  resp.className='note'; resp.textContent='در حال ارسال...';
  try{
    const res = await fetch(this.action,{method:'POST',body:fd});
    const j = await res.json();
    if(j.success){
      resp.className='success'; resp.textContent='✅ ثبت شد. این لینک غیرفعال شد. کد رهگیری: '+j.code;
      window.scrollTo({top:0,behavior:'smooth'});
    }else{
      resp.className='error'; resp.textContent='خطا: '+(j.error||'نامشخص');
    }
  }catch(err){
    resp.className='error'; resp.textContent='خطای شبکه/سرور: '+err.message;
  }
});
</script>
</body>
</html>
