<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    exit('ACCESS DENIED');
}

$id            = (int)($_POST['id'] ?? 0);
$head_username = trim($_POST['head_username'] ?? '');
$handover_date = trim($_POST['handover_date'] ?? '');
$handover_note = trim($_POST['handover_note'] ?? '');

if ($id < 1 || $head_username === '') exit('bad data');

$note_parts = [];
if ($handover_date !== '') $note_parts[] = 'تاریخ تحویل به سرباربر: '.$handover_date;
if ($handover_note !== '') $note_parts[] = 'توضیحات تحویل: '.$handover_note;
$new_status_note = implode(' | ', $note_parts);
if ($new_status_note === '') $new_status_note = 'کالا به سرباربر تحویل شد';

// آپدیت سفارش
if ($role === 'admin') {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET head_carrier_username=?, shipping_status='handover_to_head', status_note=?
        WHERE id=? LIMIT 1
    ");
    $stmt->bind_param("ssi", $head_username, $new_status_note, $id);
} else {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET head_carrier_username=?, shipping_status='handover_to_head', status_note=?
        WHERE id=? AND buyer_username=? LIMIT 1
    ");
    $stmt->bind_param("ssis", $head_username, $new_status_note, $id, $username);
}
$stmt->execute();

// نوتیفیکیشن برای سرباربر
$info = $mysqli->query("SELECT customer_name FROM orders WHERE id=".$id." LIMIT 1")->fetch_assoc();
if ($info) {
    $customer = $mysqli->real_escape_string($info['customer_name'] ?? '');
    $head     = $mysqli->real_escape_string($head_username);
    $mysqli->query("
        INSERT INTO notifications (username, type, order_id, title, message, created_at)
        VALUES (
          '$head',
          'order_assigned_head',
          $id,
          'سفارش جدید برای ارسال',
          'سفارش مشتری $customer برای ارسال آماده است.',
          NOW()
        )
    ");
}

header("Location: buyer_view.php?id=".$id);
exit;
