<?php
error_reporting(0);
ini_set('display_errors', 0);

// اتصال به دیتابیس
$db = new mysqli('localhost','slmbredirects_guaranti','Reza1372!@','slmbredirects_guaranti');
if ($db->connect_error) {
  die('<div class="error">❌ خطا در اتصال به دیتابیس.</div>');
}
$db->set_charset('utf8mb4');

$code = $_GET['code'] ?? '';
$maxInstallsPerCode = 3; // حداکثر تعداد دفعات مجاز

function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

if($code === ''){
  echo '<div class="error">❌ کد رهگیری در لینک وجود ندارد.</div>';
  exit;
}

$res = $db->query("SELECT COUNT(*) AS c FROM installations WHERE tracking_code='".$db->real_escape_string($code)."'");
$count = ($res && $r=$res->fetch_assoc()) ? intval($r['c']) : 0;

$seller   = $_GET['seller']   ?? '';
$customer = $_GET['customer'] ?? '';
$province = $_GET['province'] ?? '';
$address  = $_GET['address']  ?? '';
$mobile   = $_GET['mobile']   ?? '';
$model    = $_GET['model']    ?? '';
$warranty = $_GET['warranty'] ?? '';
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>فرم نصب انجام‌شده | سانا صنعت</title>
  <link rel="stylesheet" href="assets/style.css">
  <style>
    .status-box{background:#f8fafc;border:1px solid #ddd;padding:12px;border-radius:12px;margin:15px 0;font-size:15px;}
    .status-box strong{color:#111;}
    .warn{color:#d97706;}
    .limit{color:#dc2626;font-weight:bold;}
    .header .content h1{font-size:20px;color:#0d9488;margin:0;}
    .logo-box{text-align:center;margin-bottom:20px;}
    .logo-box img{height:60px;margin:0 auto 10px;display:block;}
  </style>
</head>
<body>
<div class="container">
  <div class="header">
    <div class="bar" style="background:linear-gradient(90deg,#3b82f6,#22c55e,#eab308,#f97316);"></div>
    <div class="content">
      <h1>فرم نصب انجام‌شده (چندبارمصرف)</h1>
    </div>
  </div>


    <div class="status-box">
      <?php if($count >= $maxInstallsPerCode): ?>
        <div class="limit">⚠️ این کد (<b><?php echo h($code); ?></b>) به سقف مجاز <?php echo $maxInstallsPerCode; ?> بار استفاده رسیده و دیگر قابل ثبت نیست.</div>
      <?php else: ?>
        <div class="warn">ℹ️ این کد تاکنون <strong><?php echo $count; ?></strong> بار استفاده شده و تا <strong><?php echo $maxInstallsPerCode; ?></strong> بار مجاز است.</div>
      <?php endif; ?>
    </div>

    <div class="preview">
      <h2>مشخصات مشتری و فروشنده</h2>
      <div class="grid-2">
        <div><label>کد رهگیری</label><input class="disabled" value="<?php echo h($code); ?>" disabled></div>
        <div><label>فروشنده</label><input class="disabled" value="<?php echo h($seller); ?>" disabled></div>
        <div><label>نام مشتری</label><input class="disabled" value="<?php echo h($customer); ?>" disabled></div>
        <div><label>استان</label><input class="disabled" value="<?php echo h($province); ?>" disabled></div>
        <div style="grid-column:1 / -1;"><label>آدرس</label><textarea class="disabled" disabled><?php echo h($address); ?></textarea></div>
        <div><label>شماره همراه</label><input class="disabled" value="<?php echo h($mobile); ?>" disabled></div>
        <div><label>مدل کالا</label><input class="disabled" value="<?php echo h($model); ?>" disabled></div>
        <div style="grid-column:1 / -1;"><label>نوع گارانتی</label><input class="disabled" value="<?php echo h($warranty); ?>" disabled></div>
      </div>
    </div>

    <?php if($count < $maxInstallsPerCode): ?>
    <hr>
    <form id="installForm" method="POST" action="db_save_install.php" enctype="multipart/form-data" novalidate>
      <input type="hidden" name="code" value="<?php echo h($code); ?>">
      <input type="hidden" name="seller" value="<?php echo h($seller); ?>">
      <input type="hidden" name="customer" value="<?php echo h($customer); ?>">
      <input type="hidden" name="province" value="<?php echo h($province); ?>">
      <input type="hidden" name="address" value="<?php echo h($address); ?>">
      <input type="hidden" name="mobile" value="<?php echo h($mobile); ?>">
      <input type="hidden" name="model" value="<?php echo h($model); ?>">
      <input type="hidden" name="warranty" value="<?php echo h($warranty); ?>">

      <h2>اطلاعات نصب توسط سرویس‌کار</h2>
      <div class="grid-2">
        <div>
          <label>نام سرویس‌کار</label>
          <input type="text" name="installer_name" required>
        </div>
        <div>
          <label>تاریخ نصب</label>
          <input type="text" name="install_date" placeholder="YYYY/MM/DD" required>
        </div>
      </div>

      <div class="grid-2">
        <div>
          <label>شماره سریال کالا</label>
          <input type="text" name="serial_number" required>
        </div>
        <div>
          <label>عکس نصب‌شده</label>
          <input type="file" name="photo" accept="image/*" required>
        </div>
      </div>

      <label>توضیحات نصب (اختیاری)</label>
      <textarea name="notes" rows="3" placeholder="مثلاً: نصب دیواری، تست تصویر، تنظیم شبکه..."></textarea>

      <div id="resp" class="note"></div>
      <br>
      <button type="submit">ثبت نهایی نصب و ارسال به تلگرام</button>
      <div class="footer">پس از ارسال موفق، دفعات استفاده در سیستم به‌روزرسانی می‌شود.</div>
    </form>
    <?php endif; ?>
  </div>
</div>

<script>
document.getElementById('installForm')?.addEventListener('submit', async function(e){
  e.preventDefault();
  const resp = document.getElementById('resp');
  resp.textContent='در حال ارسال...';
  const fd = new FormData(this);
  try{
    const res = await fetch(this.action,{method:'POST',body:fd});
    const j = await res.json();
    if(j.success){
      resp.className='success';
      resp.innerHTML='✅ ثبت شد. کد رهگیری: <b>'+j.code+'</b>';
      window.scrollTo({top:0,behavior:'smooth'});
    } else {
      resp.className='error';
      resp.textContent='خطا: '+(j.error||'نامشخص');
    }
  }catch(err){
    resp.className='error';
    resp.textContent='خطای شبکه/سرور: '+err.message;
  }
});
</script>
</body>
</html>
